// Bot Recode Bay @xvannn
// Join Room & Channel
// @Roompublicvannn
// @informationxrenders
// @informationvan

const { Telegraf } = require("telegraf");
const fs = require("fs-extra");
const path = require("path");
const JsConfuser = require("js-confuser");
const config = require("./config");
const axios = require('axios');
const { webcrack } = require("webcrack");
const crypto = require("crypto")
const { Client } = require('ssh2');
const users = new Set(loadUsers());

const bot = new Telegraf(config.BOT_TOKEN);
const userData = {};

const log = (message, error = null) => {
    const timestamp = new Date().toISOString().replace("T", " ").replace("Z", "");
    const prefix = `\x1b[36m[ Vannn Obf Bot ]\x1b[0m`;
    const timeStyle = `\x1b[33m[${timestamp}]\x1b[0m`;
    const msgStyle = `\x1b[32m${message}\x1b[0m`;
    console.log(`${prefix} ${timeStyle} ${msgStyle}`);
    if (error) {
        const errorStyle = `\x1b[31m✖ Error: ${error.message || error}\x1b[0m`;
        console.error(`${prefix} ${timeStyle} ${errorStyle}`);
        if (error.stack) console.error(`\x1b[90m${error.stack}\x1b[0m`);
    }
};

// Middleware untuk cek apakah pengguna adalah admin
const isAdmin = async (ctx, next) => {
    try {
        const chatMember = await ctx.telegram.getChatMember(ctx.chat.id, ctx.from.id);
        if (chatMember.status === 'administrator' || chatMember.status === 'creator') {
            return next();
        } else {
            return ctx.reply("❌ Anda bukan admin grup!");
        }
    } catch (error) {
        console.error("❌ Error checking admin status:", error);
        return ctx.reply("❌ Terjadi kesalahan saat memeriksa status admin.");
    }
};

// Fungsi untuk mendapatkan buffer dari URL
const getBuffer = async (url) => {
    try {
        const response = await axios.get(url, { responseType: "arraybuffer" });
        return Buffer.from(response.data);
    } catch (error) {
        console.error("Error saat mengambil buffer:", error);
        throw new Error("Gagal mengambil data dari URL");
    }
};

// Fungsi untuk mendapatkan jawaban dari API baru
async function chatbotLyyn(text) {
    try {
        const response = await axios.get(
            `https://lyyn-api.my.id/api/ai/openai?msg=${encodeURIComponent(text)}`
        );
        return response.data.result || "Maaf, saya tidak mengerti.";
    } catch (error) {
        console.error("Error:", error.response ? error.response.data : error.message);
        return "Maaf, terjadi kesalahan saat memproses permintaan.";
    }
}

// Fungsi untuk mencari video menggunakan API eksternal
async function searchYouTube(query) {
    try {
        const response = await axios.get(`https://lyyn-api.my.id/api/search/ytsearch?q=${encodeURIComponent(query)}`);
        
        if (!response.data || !response.data.result || response.data.result.length === 0) {
            console.error("❌ API tidak mengembalikan hasil yang valid.");
            return null;
        }

        return response.data.result[0]; // Ambil video pertama
    } catch (error) {
        console.error("❌ Error saat mencari video:", error.message);
        return null;
    }
}

// Fungsi untuk mengunduh file dari URL
async function downloadFile(url, filename) {
    try {
        const response = await axios({
            url,
            method: "GET",
            responseType: "stream",
        });

        return new Promise((resolve, reject) => {
            const file = fs.createWriteStream(filename);
            response.data.pipe(file);
            file.on("finish", resolve);
            file.on("error", reject);
        });
    } catch (error) {
        console.error(`❌ Error saat mengunduh file ${filename}:`, error.message);
        throw new Error("Gagal mengunduh file.");
    }
}

// Path untuk file JSON
const USERS_FILE = "./users.json";

// Fungsi untuk memuat daftar pengguna dari file (jika ada)
function loadUsers() {
    try {
        return JSON.parse(fs.readFileSync("users.json", "utf8")) || [];
    } catch (error) {
        return [];
    }
}

// Fungsi untuk menyimpan daftar pengguna ke file JSON
function saveUsers(users) {
    fs.writeFileSync("users.json", JSON.stringify([...users], null, 2));
}

// Fungsi untuk memeriksa keanggotaan channel
async function checkChannelMembership(ctx) {
    const channelId = "@informationvan"; // ID channel
    try {
        const chatMember = await ctx.telegram.getChatMember(channelId, ctx.from.id);
        return ["member", "administrator", "creator"].includes(chatMember.status);
    } catch (error) {
        log("Gagal memeriksa keanggotaan channel", error);
        return false;
    }
}


// Konstanta fungsi async untuk obfuscation Time-Locked Encryption
const obfuscateTimeLocked = async (fileContent, days) => {
    const expiryDate = new Date();
    expiryDate.setDate(expiryDate.getDate() + parseInt(days));
    const expiryTimestamp = expiryDate.getTime();
    try {
        const obfuscated = await JsConfuser.obfuscate(
            `(function(){const expiry=${expiryTimestamp};if(new Date().getTime()>expiry){throw new Error('Script has expired after ${days} days');}${fileContent}})();`,
            {
                target: "node",
                compact: true,
                renameVariables: true,
                renameGlobals: true,
                identifierGenerator: "randomized",
                stringCompression: true,
                stringConcealing: true,
                stringEncoding: true,
                controlFlowFlattening: 0.75,
                flatten: true,
                shuffle: true,
                rgf: false,
                opaquePredicates: {
                    count: 6,
                    complexity: 4
                },
                dispatcher: true,
                globalConcealing: true,
                lock: {
                    selfDefending: true,
                    antiDebug: (code) => `if(typeof debugger!=='undefined'||process.env.NODE_ENV==='debug')throw new Error('Debugging disabled');${code}`,
                    integrity: true,
                    tamperProtection: (code) => `if(!((function(){return eval('1+1')===2;})()))throw new Error('Tamper detected');${code}`
                },
                duplicateLiteralsRemoval: true
            }
        );
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        return obfuscatedCode;
    } catch (error) {
        throw new Error(`Gagal obfuscate: ${error.message}`);
    }
};

// Command /enclocked untuk enkripsi dengan masa aktif dalam hari

// Konstanta fungsi async untuk obfuscation Quantum Vortex Encryption
const obfuscateQuantum = async (fileContent) => {
    // Generate identifier unik berdasarkan waktu lokal
    const generateTimeBasedIdentifier = () => {
        const timeStamp = new Date().getTime().toString().slice(-5);
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_$#@&*";
        let identifier = "qV_";
        for (let i = 0; i < 7; i++) {
            identifier += chars[Math.floor((parseInt(timeStamp[i % 5]) + i * 2) % chars.length)];
        }
        return identifier;
    };

    // Tambahkan kode phantom berdasarkan milidetik
    const currentMilliseconds = new Date().getMilliseconds();
    const phantomCode = currentMilliseconds % 3 === 0 ? `if(Math.random()>0.999)console.log('PhantomTrigger');` : "";

    try {
        const obfuscated = await JsConfuser.obfuscate(fileContent + phantomCode, {
            target: "node",
            compact: true,
            renameVariables: true,
            renameGlobals: true,
            identifierGenerator: generateTimeBasedIdentifier,
            stringCompression: true,
            stringConcealing: false,
            stringEncoding: true,
            controlFlowFlattening: 0.85, // Intensitas lebih tinggi untuk versi 2.0
            flatten: true,
            shuffle: true,
            rgf: true,
            opaquePredicates: {
                count: 8, // Peningkatan count untuk versi 2.0
                complexity: 5
            },
            dispatcher: true,
            globalConcealing: true,
            lock: {
                selfDefending: true,
                antiDebug: (code) => `if(typeof debugger!=='undefined'||(typeof process!=='undefined'&&process.env.NODE_ENV==='debug'))throw new Error('Debugging disabled');${code}`,
                integrity: true,
                tamperProtection: (code) => `if(!((function(){return eval('1+1')===2;})()))throw new Error('Tamper detected');${code}`
            },
            duplicateLiteralsRemoval: true
        });
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        // Self-evolving code dengan XOR dinamis
        const key = currentMilliseconds % 256;
        obfuscatedCode = `(function(){let k=${key};return function(c){return c.split('').map((x,i)=>String.fromCharCode(x.charCodeAt(0)^(k+(i%16)))).join('');}('${obfuscatedCode}');})()`;
        return obfuscatedCode;
    } catch (error) {
        throw new Error(`Gagal obfuscate: ${error.message}`);
    }
};

// Command /encquantum untuk enkripsi Quantum Vortex Encryption


// Konfigurasi obfuscation untuk Siu + Calcrick style dengan keamanan ekstrem
const getSiuCalcrickObfuscationConfig = () => {
    const generateSiuCalcrickName = () => {
        // Identifier generator pseudo-random tanpa crypto
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        let randomPart = "";
        for (let i = 0; i < 6; i++) { // 6 karakter untuk keseimbangan
            randomPart += chars[Math.floor(Math.random() * chars.length)];
        }
        return `CalceDanz和SiuSiu无与伦比的帅气${randomPart}`;
    };

    return {
    target: "node",
    compact: true,
    renameVariables: true,
    renameGlobals: true,
    identifierGenerator: generateSiuCalcrickName,
    stringCompression: true,       
        stringEncoding: true,           
        stringSplitting: true,      
    controlFlowFlattening: 0.95,
    shuffle: true,
        rgf: false,
        flatten: true,
    duplicateLiteralsRemoval: true,
    deadCode: true,
    calculator: true,
    opaquePredicates: true,
    lock: {
        selfDefending: true,
        antiDebug: true,
        integrity: true,
        tamperProtection: true
        }
    };
};

// Command /encsiucalcrick

// Command /encgalaxy

// Konfigurasi obfuscation untuk Nebula style dengan banyak opsi aktif
const getNebulaObfuscationConfig = () => {
    const generateNebulaName = () => {
        // Identifier generator pseudo-random tanpa crypto atau timeHash
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        const prefix = "NX";
        let randomPart = "";
        for (let i = 0; i < 4; i++) {
            randomPart += chars[Math.floor(Math.random() * chars.length)];
        }
        return `${prefix}${randomPart}`;
    };

    return {
        target: "node",
        compact: true,                  // Minimalkan whitespace
        renameVariables: true,          // Rename variabel
        renameGlobals: true,            // Rename global untuk keamanan
        identifierGenerator: generateNebulaName,
        stringCompression: true,        // Kompresi string
        stringConcealing: false,         // Sembunyikan string
        stringEncoding: true,           // Enkripsi string
        stringSplitting: false,          // Pecah string untuk kebingungan
        controlFlowFlattening: 0.75,     // Aktif dengan intensitas sedang
        flatten: true,                  // Ratakan struktur kode
        shuffle: true,                  // Acak urutan eksekusi
        rgf: true,                      // Randomized Global Functions
        deadCode: true,                 // Tambah kode mati untuk kebingungan
        opaquePredicates: true,         // Predikat buram
        dispatcher: true,               // Acak eksekusi fungsi
        globalConcealing: true,         // Sembunyikan variabel global
        objectExtraction: true,         // Ekstrak objek untuk kebingungan
        duplicateLiteralsRemoval: true,// Pertahankan duplikat untuk kebingungan
        lock: {
            selfDefending: true,        // Lindungi dari modifikasi
            antiDebug: true,            // Cegah debugging
            integrity: true,            // Pastikan integritas
            tamperProtection: true      // Lindungi dari tampering
        }
    };
};

// Fungsi invisible encoding yang efisien dan kecil
function encodeInvisible(text) {
    try {
        // Kompresi kode dengan menghapus spasi berlebih
        const compressedText = text.replace(/\s+/g, ' ').trim();
        // Gunakan base64 untuk efisiensi
        const base64Text = Buffer.from(compressedText).toString('base64');
        // Tambahkan penanda invisible di awal
        return '\u200B' + base64Text; // Hanya penanda awal untuk invisibility minimal
    } catch (e) {
        log("Gagal encode invisible", e);
        return Buffer.from(text).toString('base64'); // Fallback ke base64
    }
}


// Konfigurasi obfuscation untuk Nova style
const getNovaObfuscationConfig = () => {
    const generateNovaName = () => {
        // Identifier generator unik dan keren
        const prefixes = ["nZ", "nova", "nx"];
        const randomPrefix = prefixes[Math.floor(Math.random() * prefixes.length)];
        const hash = crypto.createHash('sha256')
            .update(crypto.randomBytes(8))
            .digest('hex')
            .slice(0, 6); // Ambil 6 karakter pertama dari hash SHA-256
        const suffix = Math.random().toString(36).slice(2, 5); // Sufiks acak 3 karakter
        return `${randomPrefix}_${hash}_${suffix}`;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: generateNovaName, 
        stringCompression: true,
        stringConcealing: true,
        stringEncoding: true,
        stringSplitting: false,
        controlFlowFlattening: 0.5, 
        flatten: true,
        shuffle: true,
        rgf: false,
        deadCode: false, 
        opaquePredicates: true,
        dispatcher: true,
        globalConcealing: true,
        objectExtraction: true,
        duplicateLiteralsRemoval: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};


// Fungsi decode invisible yang efisien
function decodeInvisible(encodedText) {
    try {
        if (!encodedText.startsWith('\u200B')) return encodedText; // Fallback jika tidak ada penanda
        const base64Text = encodedText.slice(1); // Hapus penanda invisible
        return Buffer.from(base64Text, 'base64').toString('utf-8');
    } catch (e) {
        log("Gagal decode invisible", e);
        return encodedText; // Fallback ke teks asli
    }
}

// Konfigurasi obfuscation untuk X style
const getXObfuscationConfig = () => {
    const generateXName = () => {
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        return "xZ" + crypto.randomUUID().slice(0, 4); // Nama pendek dan unik
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateXName(),
        stringCompression: true,
        stringConcealing: true,
        stringEncoding: true,
        stringSplitting: false,
        controlFlowFlattening: 0.5, // Stabil dan aman
        flatten: true,
        shuffle: true,
        rgf: true,
        deadCode: false, // Nonaktif untuk ukuran kecil
        opaquePredicates: true,
        dispatcher: true,
        globalConcealing: true,
        objectExtraction: true,
        duplicateLiteralsRemoval: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Max style dengan intensitas yang dapat diatur
const getMaxObfuscationConfig = (intensity) => {
    const generateMaxName = () => {
        // Nama variabel unik: prefiks "mX" + kombinasi acak
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        const length = Math.floor(Math.random() * 4) + 4; // 4-7 karakter
        let name = "mX";
        for (let i = 0; i < length; i++) {
            name += chars[Math.floor(Math.random() * chars.length)];
        }
        return name;
    };

    // Skala intensitas dari 1-10 ke 0.1-1.0 untuk controlFlowFlattening
    const flatteningLevel = intensity / 10;

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateMaxName(),
        stringCompression: true, // Kompresi string
        stringConcealing: true, // Menyembunyikan string
        stringEncoding: true, // Enkripsi string
        stringSplitting: true, // Memecah string
        controlFlowFlattening: flatteningLevel, // Intensitas berdasarkan input (0.1-1.0)
        flatten: true, // Meratakan struktur kontrol
        shuffle: true, // Mengacak urutan
        rgf: true, // Randomized Global Functions
        calculator: true, // Mengacak operasi matematika
        deadCode: true,
        opaquePredicates: true,
        dispatcher: true, // Mengacak eksekusi
        globalConcealing: true, // Menyembunyikan variabel global
        objectExtraction: true, // Mengekstrak objek untuk kebingungan
        duplicateLiteralsRemoval: false, // Menjaga redundansi
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};


// Konfigurasi obfuscation standar (diperkuat dan aman)
const getObfuscationConfig = (level = "high") => ({
    target: "node",
    compact: true,
    renameVariables: true,
    renameGlobals: true,
    identifierGenerator: "mangled",
    stringEncoding: true,
    stringSplitting: true,
    controlFlowFlattening: level === "high" ? 0.95 : level === "medium" ? 0.75 : 0.5,
    shuffle: true,
    duplicateLiteralsRemoval: true,
    deadCode: true,
    calculator: true,
    opaquePredicates: true,
    lock: {
        selfDefending: true,
        antiDebug: true,
        integrity: true,
        tamperProtection: true
    }
});

// Konfigurasi obfuscation untuk Strong style (diperbaiki berdasarkan dokumentasi)
const getStrongObfuscationConfig = () => {
    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: "randomized", // Valid: menghasilkan nama acak
        stringEncoding: true, // Valid: mengenkripsi string
        stringSplitting: true, // Valid: memecah string
        controlFlowFlattening: 0.75, // Valid: mengacak alur kontrol
        duplicateLiteralsRemoval: true, // Valid: menghapus literal duplikat
        calculator: true, // Valid: mengacak operasi matematika
        dispatcher: true, // Valid: mengacak eksekusi dengan dispatcher
        deadCode: true, // Valid: menambahkan kode mati
        opaquePredicates: true, // Valid: menambahkan predikat buram
        lock: {
            selfDefending: true, // Valid: mencegah modifikasi
            antiDebug: true, // Valid: mencegah debugging
            integrity: true, // Valid: memastikan integritas
            tamperProtection: true // Valid: perlindungan tamper
        }
    };
};

// Konfigurasi obfuscation untuk Big style (ukuran file besar)
const getBigObfuscationConfig = () => {
    const generateBigName = () => {
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        const length = Math.floor(Math.random() * 5) + 5; // Nama 5-9 karakter
        let name = "";
        for (let i = 0; i < length; i++) {
            name += chars[Math.floor(Math.random() * chars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateBigName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.75, // Stabil dan kuat
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};


// Konfigurasi obfuscation untuk Invisible style (diperbaiki)
const getInvisObfuscationConfig = () => {
    const generateInvisName = () => {
        const length = Math.floor(Math.random() * 4) + 3; // Panjang 3-6 karakter
        let name = "";
        for (let i = 0; i < length; i++) {
            name += "_"; // Menggunakan underscore untuk "invis" yang aman
        }
        // Tambahkan variasi acak agar unik
        return name + Math.random().toString(36).substring(2, 5);
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateInvisName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.95,
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        calculator: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Stealth style (diperbaiki untuk stabilitas)
const getStealthObfuscationConfig = () => {
    const generateStealthName = () => {
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
        const length = Math.floor(Math.random() * 3) + 1; // Nama pendek 1-3 karakter
        let name = "";
        for (let i = 0; i < length; i++) {
            name += chars[Math.floor(Math.random() * chars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateStealthName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.75, // Dikurangi untuk stabilitas
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Custom style (dengan nama kustom)
const getCustomObfuscationConfig = (customName) => {
    const generateCustomName = () => {
        const chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        const randomSuffixLength = Math.floor(Math.random() * 3) + 2; // Sufiks acak 2-4 karakter
        let suffix = "";
        for (let i = 0; i < randomSuffixLength; i++) {
            suffix += chars[Math.floor(Math.random() * chars.length)];
        }
        // Gunakan nama kustom sebagai prefiks, tambahkan sufiks acak
        return `${customName}_${suffix}`;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateCustomName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.75, // Stabil dan kuat
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Mandarin style (diperkuat dan aman)
const getMandarinObfuscationConfig = () => {
    const mandarinChars = [
        "龙", "虎", "风", "云", "山", "河", "天", "地", "雷", "电",
        "火", "水", "木", "金", "土", "星", "月", "日", "光", "影",
        "峰", "泉", "林", "海", "雪", "霜", "雾", "冰", "焰", "石"
    ];

    const generateMandarinName = () => {
        const length = Math.floor(Math.random() * 4) + 3;
        let name = "";
        for (let i = 0; i < length; i++) {
            name += mandarinChars[Math.floor(Math.random() * mandarinChars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateMandarinName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.95,
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        calculator: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Arab style (diperkuat dan aman)
const getArabObfuscationConfig = () => {
    const arabicChars = [
        "أ", "ب", "ت", "ث", "ج", "ح", "خ", "د", "ذ", "ر",
        "ز", "س", "ش", "ص", "ض", "ط", "ظ", "ع", "غ", "ف",
        "ق", "ك", "ل", "م", "ن", "ه", "و", "ي"
    ];

    const generateArabicName = () => {
        const length = Math.floor(Math.random() * 4) + 3;
        let name = "";
        for (let i = 0; i < length; i++) {
            name += arabicChars[Math.floor(Math.random() * arabicChars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateArabicName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.95,
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        calculator: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

const getJapanxArabObfuscationConfig = () => {
    const japaneseXArabChars = [
        "あ", "い", "う", "え", "お", "か", "き", "く", "け", "こ",
        "さ", "し", "す", "せ", "そ", "た", "ち", "つ", "て", "と",
        "な", "に", "ぬ", "ね", "の", "は", "ひ", "ふ", "へ", "ほ",
        "ま", "み", "む", "め", "も", "や", "ゆ", "よ","أ", "ب", "ت", "ث", "ج", "ح", "خ", "د", "ذ", "ر",
        "ز", "س", "ش", "ص", "ض", "ط", "ظ", "ع", "غ", "ف",
        "ق", "ك", "ل", "م", "ن", "ه", "و", "ي","ら", "り", "る", "れ", "ろ", "わ", "を", "ん" 
    ];

    const generateJapaneseXArabName = () => {
        const length = Math.floor(Math.random() * 4) + 3; // Panjang 3-6 karakter
        let name = "";
        for (let i = 0; i < length; i++) {
            name += japaneseXArabChars[Math.floor(Math.random() * japaneseXArabChars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateJapaneseXArabName(),
        stringCompression: true, // Kompresi string
        stringConcealing: true, // Menyembunyikan string
        stringEncoding: true, // Enkripsi string
        stringSplitting: true, // Memecah string        
        controlFlowFlattening: 0.95, // Sedikit lebih rendah untuk variasi
        flatten: true,              // Metode baru: mengganti struktur kontrol
        shuffle: true,
        rgf: false,
        dispatcher: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        calculator: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};
const getUltraObfuscationConfig = () => {
    const generateUltraName = () => {
        const chars = "abcdefghijklmnopqrstuvwxyz";
        const numbers = "0123456789";
        const randomNum = numbers[Math.floor(Math.random() * numbers.length)];
        const randomChar = chars[Math.floor(Math.random() * chars.length)];
        return `z${randomNum}${randomChar}${Math.random().toString(36).substring(2, 6)}`;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateUltraName(),
        stringCompression: true, // Kompresi string untuk keamanan tinggi
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.9,
        flatten: true,
        shuffle: true,
        rgf: true, // Randomized Global Functions
        deadCode: true,
        opaquePredicates: true,
        dispatcher: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk Japan style (diperkuat dan aman)
const getJapanObfuscationConfig = () => {
    const japaneseChars = [
        "あ", "い", "う", "え", "お", "か", "き", "く", "け", "こ",
        "さ", "し", "す", "せ", "そ", "た", "ち", "つ", "て", "と",
        "な", "に", "ぬ", "ね", "の", "は", "ひ", "ふ", "へ", "ほ",
        "ま", "み", "む", "め", "も", "や", "ゆ", "よ",
        "ら", "り", "る", "れ", "ろ", "わ", "を", "ん"
    ];

    const generateJapaneseName = () => {
        const length = Math.floor(Math.random() * 4) + 3; // Panjang 3-6 karakter
        let name = "";
        for (let i = 0; i < length; i++) {
            name += japaneseChars[Math.floor(Math.random() * japaneseChars.length)];
        }
        return name;
    };

    return {
        target: "node",
        compact: true,
        renameVariables: true,
        renameGlobals: true,
        identifierGenerator: () => generateJapaneseName(),
        stringEncoding: true,
        stringSplitting: true,
        controlFlowFlattening: 0.9, // Sedikit lebih rendah untuk variasi
        flatten: true,              // Metode baru: mengganti struktur kontrol
        shuffle: true,
        duplicateLiteralsRemoval: true,
        deadCode: true,
        calculator: true,
        opaquePredicates: true,
        lock: {
            selfDefending: true,
            antiDebug: true,
            integrity: true,
            tamperProtection: true
        }
    };
};

// Konfigurasi obfuscation untuk /encnew (diperkuat dan aman)
const getNewObfuscationConfig = () => ({
    target: "node",
    compact: true,
    renameVariables: true,
    renameGlobals: true,
    identifierGenerator: "mangled",
    stringEncoding: true,
    stringSplitting: true,
    controlFlowFlattening: 0.95,
    shuffle: true,
    duplicateLiteralsRemoval: true,
    deadCode: true,
    calculator: true,
    opaquePredicates: true,
    lock: {
        selfDefending: true,
        antiDebug: true,
        integrity: true,
        tamperProtection: true
    }
});

// Progress bar
const createProgressBar = (percentage) => {
    const total = 10;
    const filled = Math.round((percentage / 100) * total);
    return "▰".repeat(filled) + "▱".repeat(total - filled);
};

// Update progress
async function updateProgress(ctx, message, percentage, status) {
    const bar = createProgressBar(percentage);
    const levelText = percentage === 100 ? "✅ Selesai" : `⚙️ ${status}`;
    try {
        await ctx.telegram.editMessageText(
            ctx.chat.id,
            message.message_id,
            null,
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ${levelText} (${percentage}%)\n` +
            ` ${bar}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN",
            { parse_mode: "Markdown" }
        );
        await new Promise(resolve => setTimeout(resolve, Math.min(800, percentage * 8)));
    } catch (error) {
        log("Gagal memperbarui progres", error);
    }
}


// Command /start untuk menyapa pengguna dan menampilkan menu
bot.start(async (ctx) => {
    try {
        users.add(ctx.from.id);
        saveUsers(users);
        await ctx.telegram.sendChatAction(ctx.chat.id, 'typing');

        const username = ctx.from.username ? `@${ctx.from.username}` : "Tidak Diketahui";
        const chatId = ctx.from.id;

        const inlineKeyboard = [
            [
                { text: '『 𝐂̽͢𝐇᷍𝐀᳑᷼𝐍⃪⃯͒𝐍𑂺͢𝐄᭄𝐋🔊 』', url: 'https://t.me/informationvan' },
                { text: '『 𝐃̽͢𝐄᷍𝐕᳑᷼𝐄⃪⃯͒𝐋𑂺͢𝐎᭄𝐏𝐄𝐑👤 』', url: 'https://t.me/xvannn' }
            ],
            [              
                { text: '『 𝐄̽͢𝐍᷍𝐂᳑᷼𝐑⃪⃯͒𝐘𑂺͢𝐏᭄𝐓 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔🚨 』', callback_data: 'encrypt_menu' },
                { text: '『 𝐂̽͢𝐎᷍𝐍᳑᷼𝐓⃪⃯͒𝐑𑂺͢𝐎᭄𝐋𝐋𝐄𝐑 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔⚙️ 』', callback_data: 'controller_menu' }
            ],
            [
                { text: '『 𝐆̽͢𝐑᷍𝐎᳑᷼𝐔⃪⃯͒𝐏 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔📌 』', callback_data: 'group_menu' }
            ]
        ];

        setTimeout(async () => {
            await ctx.replyWithPhoto("https://files.catbox.moe/0memo2.jpg", {
                caption: `
👋 Привет, пользователь, вы готовы защитить свой скрипт с помощью супербезопасности?
 Отлично! Этот бот используется для шифрования скрипта с высоким уровнем безопасности.
 
╔═─═⊱『 𝐈𝐍𝐅𝐎𝐑𝐌𝐀𝐓𝐈𝐎𝐍 』
┃ Username : ${username}
┃ UserID : ${chatId}
┃𝚂𝙸𝙻𝙰𝙷𝙺𝙰𝙽 𝙿𝙸𝙻𝙸𝙷 𝙵𝙸𝚃𝚄𝚁 𝙳𝙸 𝙱𝙰𝚆𝙰𝙷 𝙸𝙽𝙸
╰═─══─══─══─══─══─══─❍
                `,
                parse_mode: "Markdown",
                reply_markup: {
                    inline_keyboard: inlineKeyboard
                }
            });
        }, 1000); // Delay 1 detik
    } catch (error) {
        console.error("Error saat memulai bot:", error);
    }
});

bot.action("encrypt_menu", (ctx) => {
    ctx.editMessageCaption(`
╭═─═─═─═⊱ 𝐂̽͢𝐎᷍𝐌᳑᷼𝐌⃪⃯͒𝐀̽͢𝐍᷍𝐃᳑᷼ 
│ 𖹬 /enc <LEVEL> - STANDARD
│ 𖹬 /enceval <LEVEL> - EVALUATE
│ 𖹬 /encchina - MANDARIN
│ 𖹬 /encarab - ARABIC
│ 𖹬 /encjapan - JAPANESE
│ 𖹬 /encinvis - INVISIBLE
│ 𖹬 /encjapxab - JAPAN X ARAB
│ 𖹬 /encx - BASE 64
│ 𖹬 /encnebula - HARD
│ 𖹬 /encnova - NOVA
│ 𖹬 /encsiu - SIU + CALCRICK 
│ 𖹬 /customenc <NAME> - DESIGN
│ 𖹬 /encmax <INTENSITY> - INTENSITY
│ 𖹬 /encstralth - STEALTH
│ 𖹬 /encstrong - POWER 
│ 𖹬 /encultra - ULTRA 
│ 𖹬 /deobfuscate - DECRYPT 
│ 𖹬 /encbig <MB> - MEGABYTE
│ 𖹬 /encnew - ADVANCED
│ 𖹬 /encquantum - QUANTUM
│ 𖹬 /enclocked - HARD
╚─═─═─═─═─═─═─═─═─═─⊱
    `, {
        parse_mode: "Markdown",
        reply_markup: {
            inline_keyboard: [
                [{ text: '🔙 BACK', callback_data: 'start_menu' }]
            ]
        }
    });
});

// Action untuk tombol "Settings" (placeholder)
bot.action("controller_menu", (ctx) => {
    ctx.editMessageCaption(`
┏═━═━═━═⫹⫺ 𝐂̽͢𝐎᷍𝐍᳑᷼𝐓⃪⃯͒𝐑𝐎̽͢𝐋᷍𝐋᳑᷼𝐄⃪⃯͒𝐑
│ 𖹬 /broadcast <teks>
│ 𖹬 /listusr
│ 𖹬 /brat <teks>
│ 𖹬 /chatai <teks>
│ 𖹬 /play <teks>
│ 𖹬 /ttmp4 <teks>
╚━═━═━═━═━═━═━═━❍
    `, {
        parse_mode: "Markdown",
        reply_markup: {
            inline_keyboard: [
                [{ text: '🔙 BACK', callback_data: 'start_menu' }]
            ]
        }
    });
});

// Action untuk tombol "Settings" (placeholder)
bot.action("group_menu", (ctx) => {
    ctx.editMessageCaption(`
┏═━═━═━═⫹⫺ 𝐂̽͢𝐎᷍𝐍᳑᷼𝐓⃪⃯͒𝐑𝐎̽͢𝐋᷍𝐋᳑᷼𝐄⃪⃯͒𝐑
│ 𖹬 /mute <reply pesan>
│ 𖹬 /unmute <reply pesan>
│ 𖹬 /ban <reply pesan>
│ 𖹬 /unban <reply pesan>
│ 𖹬 /kick <reply pesan>
╚━═━═━═━═━═━═━═━❍
    `, {
        parse_mode: "Markdown",
        reply_markup: {
            inline_keyboard: [
                [{ text: '🔙 BACK', callback_data: 'start_menu' }]
            ]
        }
    });
});

// Action untuk kembali ke menu utama
bot.action("start_menu", async (ctx) => {
    try {
        const username = ctx.from.username ? `@${ctx.from.username}` : "Tidak Diketahui";
        const chatId = ctx.from.id;

        await ctx.editMessageCaption(`
👋 Привет, пользователь, вы готовы защитить свой скрипт с помощью супербезопасности?
 Отлично! Этот бот используется для шифрования скрипта с высоким уровнем безопасности.
 
╔═─═⊱『 𝐈𝐍𝐅𝐎𝐑𝐌𝐀𝐓𝐈𝐎𝐍 』
┃ Username : ${username}
┃ UserID : ${chatId}
┃𝚂𝙸𝙻𝙰𝙷𝙺𝙰𝙽 𝙿𝙸𝙻𝙸𝙷 𝙵𝙸𝚃𝚄𝚁 𝙳𝙸 𝙱𝙰𝚆𝙰𝙷 𝙸𝙽𝙸
╰═─══─══─══─══─══─══─❍
        `, {
            parse_mode: "Markdown",
            reply_markup: {
                inline_keyboard: [
                    [
                        { text: '『 𝐂̽͢𝐇᷍𝐀᳑᷼𝐍⃪⃯͒𝐍𑂺͢𝐄᭄𝐋🔊 』', url: 'https://t.me/informationvan' },
                        { text: '『 𝐃̽͢𝐄᷍𝐕᳑᷼𝐄⃪⃯͒𝐋𑂺͢𝐎᭄𝐏𝐄𝐑👤 』', url: 'https://t.me/xvannn' }
                    ],
                    [              
                        { text: '『 𝐄̽͢𝐍᷍𝐂᳑᷼𝐑⃪⃯͒𝐘𑂺͢𝐏᭄𝐓 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔🚨 』', callback_data: 'encrypt_menu' },           
                        { text: '『 𝐂̽͢𝐎᷍𝐍᳑᷼𝐓⃪⃯͒𝐑𑂺͢𝐎᭄𝐋𝐋𝐄𝐑 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔⚙️ 』', callback_data: 'controller_menu' }
                    ],
                    [
                        { text: '『 𝐆̽͢𝐑᷍𝐎᳑᷼𝐔⃪⃯͒𝐏 𝐌̽͢𝐄᷍𝐍᳑᷼𝐔📌 』', callback_data: 'group_menu' }
                    ]
                ]
            }
        });
    } catch (error) {
        console.error("Error saat memulai bot:", error);
    }
});

bot.command("broadcast", async (ctx) => {
// Tambahkan pengguna ke daftar broadcast
users.add(ctx.from.id);
saveUsers(users);

// Hanya admin yang bisa broadcast  
if (ctx.from.id !== config.ADMIN_ID) {  
    return ctx.replyWithMarkdown("❌ *Akses Ditolak:* Hanya admin yang bisa menggunakan perintah ini!");  
}  

let message = ctx.message.text.split(" ").slice(1).join(" ");  
let photo = null;  

// Cek apakah perintah dikirim sebagai balasan ke foto  
if (ctx.message.reply_to_message && ctx.message.reply_to_message.photo) {  
    const photos = ctx.message.reply_to_message.photo;  
    photo = photos[photos.length - 1].file_id; // Ambil resolusi tertinggi  
    message = message || ctx.message.reply_to_message.caption || "📢 Broadcast!";  
}  

if (!message && !photo) {  
    return ctx.replyWithMarkdown("❌ *Error:* Tulis pesan untuk broadcast atau balas gambar dengan `/broadcast`.");  
}  

log(`Mengirim broadcast: ${message}`);  
let successCount = 0;  
let failCount = 0;  

for (const userId of users) {  
    try {  
        if (photo) {  
            await bot.telegram.sendPhoto(userId, photo, { caption: message, parse_mode: "Markdown" });  
        } else {  
            await bot.telegram.sendMessage(userId, message, { parse_mode: "Markdown" });  
        }  
        successCount++;  
    } catch (error) {  
        log(`Gagal mengirim ke ${userId}`, error);  
        failCount++;  
    }  
}  

await ctx.replyWithMarkdown(  
    `📢 *Broadcast Selesai:*\n` +  
    `- Berhasil dikirim ke: ${successCount} pengguna\n` +  
    `- Gagal dikirim ke: ${failCount} pengguna`  
);

});

bot.command("listusr", async (ctx) => {
    if (ctx.from.id !== config.ADMIN_ID) {
        return ctx.replyWithMarkdown("❌ *Akses Ditolak:* Hanya admin yang bisa melihat daftar pengguna!");
    }

    if (users.size === 0) {
        return ctx.reply("📋 Tidak ada pengguna yang terdaftar.");
    }

    let userList = "📋 *Daftar Pengguna Bot:*\n";
    
    let userData = await Promise.all([...users].map(async (id, index) => {
        try {
            let user = await bot.telegram.getChat(id);
            let username = user.username ? `(@${user.username})` : "";
            return `${index + 1}. \`${id}\` ${username}`;
        } catch (error) {
            return `${index + 1}. \`${id}\` (Tidak dapat mengambil info)`;
        }
    }));

    userList += userData.join("\n");

    await ctx.replyWithMarkdown(userList);
});

// Perintah MUTE (hanya dengan reply)
bot.command('mute', isAdmin, async (ctx) => {
    try {
        if (!ctx.message.reply_to_message) {
            return ctx.reply("❌ Balas pesan pengguna yang ingin di-mute.");
        }

        const targetUser = ctx.message.reply_to_message.from;
        
        await ctx.telegram.restrictChatMember(ctx.chat.id, targetUser.id, {
            permissions: { can_send_messages: false }
        });

        await ctx.reply(`✅ Pengguna [${targetUser.first_name}](tg://user?id=${targetUser.id}) telah di-mute.`, { parse_mode: "Markdown" });

        // Kirim pesan langsung ke pengguna yang di-mute
        await ctx.replyWithMarkdown(`🚫 *Pengguna telah di-mute di grup ini oleh admin.*`, {
            reply_to_message_id: ctx.message.reply_to_message.message_id
        });
    } catch (error) {
        console.error("❌ Error muting user:", error);
        ctx.reply("❌ Gagal melakukan mute.");
    }
});

// Perintah UNMUTE (hanya dengan reply)
bot.command('unmute', isAdmin, async (ctx) => {
    try {
        if (!ctx.message.reply_to_message) {
            return ctx.reply("❌ Balas pesan pengguna yang ingin di-unmute.");
        }

        const targetUser = ctx.message.reply_to_message.from;

        await ctx.telegram.restrictChatMember(ctx.chat.id, targetUser.id, {
            permissions: {
                can_send_messages: true,
                can_send_media_messages: true,
                can_send_other_messages: true,
                can_add_web_page_previews: true
            }
        });

        await ctx.reply(`✅ Pengguna [${targetUser.first_name}](tg://user?id=${targetUser.id}) telah di-unmute.`, { parse_mode: "Markdown" });

        // Kirim pesan langsung ke pengguna yang di-unmute
        await ctx.replyWithMarkdown(`🔊 *Pengguna telah di-unmute di grup ini, silakan mengobrol kembali.*`, {
            reply_to_message_id: ctx.message.reply_to_message.message_id
        });
    } catch (error) {
        console.error("❌ Error unmuting user:", error);
        ctx.reply("❌ Gagal melakukan unmute.");
    }
});

// Perintah BAN (hanya dengan reply)
bot.command('ban', isAdmin, async (ctx) => {
    try {
        if (!ctx.message.reply_to_message) {
            return ctx.reply("❌ Balas pesan pengguna yang ingin di-ban.");
        }

        const targetUser = ctx.message.reply_to_message.from;

        await ctx.telegram.banChatMember(ctx.chat.id, targetUser.id);

        await ctx.reply(`✅ Pengguna [${targetUser.first_name}](tg://user?id=${targetUser.id}) telah di-ban.`, { parse_mode: "Markdown" });

        // Kirim pesan langsung ke pengguna yang di-ban
        await ctx.replyWithMarkdown(`🚫 *Pengguna telah di-ban dari grup ini oleh admin.*`);
    } catch (error) {
        console.error("❌ Error banning user:", error);
        ctx.reply("❌ Gagal melakukan ban.");
    }
});

// Perintah UNBAN (hanya dengan reply)
bot.command('unban', isAdmin, async (ctx) => {
    try {
        if (!ctx.message.reply_to_message) {
            return ctx.reply("❌ Balas pesan pengguna yang ingin di-unban.");
        }

        const targetUser = ctx.message.reply_to_message.from;

        await ctx.telegram.unbanChatMember(ctx.chat.id, targetUser.id);

        await ctx.reply(`✅ Pengguna [${targetUser.first_name}](tg://user?id=${targetUser.id}) telah di-unban.`, { parse_mode: "Markdown" });

        // Kirim pesan langsung ke pengguna yang di-unban
        await ctx.replyWithMarkdown(`🔓 *Pengguna telah di-unban dari grup ini, silakan bergabung kembali.*`);
    } catch (error) {
        console.error("❌ Error unbanning user:", error);
        ctx.reply("❌ Gagal melakukan unban.");
    }
});

// Perintah KICK (hanya dengan reply)
bot.command('kick', isAdmin, async (ctx) => {
    try {
        if (!ctx.message.reply_to_message) {
            return ctx.reply("❌ Balas pesan pengguna yang ingin di-kick.");
        }

        const targetUser = ctx.message.reply_to_message.from;

        // Kick user dari grup (ban dan langsung unban agar bisa join kembali)
        await ctx.telegram.banChatMember(ctx.chat.id, targetUser.id);
        await ctx.telegram.unbanChatMember(ctx.chat.id, targetUser.id);

        await ctx.reply(`✅ Pengguna [${targetUser.first_name}](tg://user?id=${targetUser.id}) telah di-kick.`, { parse_mode: "Markdown" });

        // Kirim pesan langsung ke pengguna yang di-kick
        await ctx.replyWithMarkdown(`👢 *Pengguna telah di-kick dari grup ini oleh admin. Pengguna dapat bergabung kembali jika diperbolehkan.*`);
    } catch (error) {
        console.error("❌ Error kicking user:", error);
        ctx.reply("❌ Gagal melakukan kick.");
    }
});

bot.command("brat", async (ctx) => {
    users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ғɪᴛᴜʀ ɪɴɪ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    const text = ctx.message.text.split(" ").slice(1).join(" ");
    if (!text) {
        return ctx.replyWithMarkdown("❌ *Error:* Masukkan teks! Contoh: `/brat teksnya`");
    }

    log(`Membuat stiker brat: ${text}`);

    try {
        const res = await getBuffer(`https://brat.caliphdev.com/api/brat?text=${encodeURIComponent(text)}`);

        await bot.telegram.sendSticker(ctx.from.id, { source: res }, {
            packname: global.packname || "Danz",
            author: global.author || "Sigma",
        });

        await ctx.replyWithMarkdown("📢 *Stiker Brat telah dikirim kepadamu!*");
    } catch (error) {
        log(`Gagal mengirim stiker ke ${ctx.from.id}`, error);
        await ctx.replyWithMarkdown("❌ *Error:* Gagal mengirim stiker brat!");
    }
});

// Command bot untuk chatbot dengan API baru
bot.command("chatai", async (ctx) => {
    try {
        const text = ctx.message.text.split(" ").slice(1).join(" "); // Ambil teks setelah /chatai
        
        if (!text) {
            return ctx.reply("❌ Error: Masukkan pertanyaan! Contoh: /chatai Apa kabar?");
        }

        // Cek keanggotaan pengguna di channel
        const isMember = await checkChannelMembership(ctx);
        if (!isMember) {
            return ctx.replyWithMarkdown(
                "❌ E̶R̶R̶O̶R̶ │ ⓘ Anda harus bergabung ke channel di bawah ini terlebih dahulu sebelum memakai fitur ini!!",
                {
                    reply_markup: {
                        inline_keyboard: [
                            [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                        ]
                    }
                }
            );
        }

        // Simpan pengguna (asumsi users adalah Set atau Array)
        users.add(ctx.from.id);
        saveUsers(users);

        // Beri tahu pengguna bahwa proses sedang berlangsung
        ctx.reply("⏳ Sedang memproses jawaban...");

        // Panggil chatbot API
        const response = await chatbotLyyn(text);
        ctx.reply(response);
    } catch (error) {
        console.error(error); // Log error agar lebih mudah debug
        ctx.reply("❌ Error: Terjadi kesalahan saat mengambil respons dari chatai.");
    }
});

// Fungsi utama untuk menangani perintah /play
bot.command("play", async (ctx) => {
    const text = ctx.message.text.split(" ").slice(1).join(" ");

    if (!text) {
        return ctx.reply("❌ Masukkan kata kunci!\n\nContoh: /play dj tiktok");
    }

    await ctx.reply("🔎 Sedang mencari video...");

    try {
        // Cari video menggunakan API eksternal
        const video = await searchYouTube(text);
        if (!video || !video.url) {
            return ctx.reply("❌ Tidak ditemukan hasil untuk kata kunci tersebut. Coba gunakan kata kunci lain.");
        }

        const videoUrl = video.url;
        const videoFileName = `${video.videoId}.mp4`;
        const audioFileName = `${video.videoId}.mp3`;

        await ctx.reply(`✅ Video ditemukan: *${video.title}*\n🔗 ${video.url}\n\n⏳ Sedang mengunduh...`, { parse_mode: "Markdown" });

        // Ambil URL download dari API eksternal
        const videoDownloadResponse = await axios.get(`https://lyyn-api.my.id/api/download/ytmp4?url=${encodeURIComponent(videoUrl)}`);
        const audioDownloadResponse = await axios.get(`https://lyyn-api.my.id/api/download/ytmp3?url=${encodeURIComponent(videoUrl)}`);

        if (!videoDownloadResponse.data.result || !audioDownloadResponse.data.result) {
            return ctx.reply("❌ Gagal mendapatkan link unduhan dari API.");
        }

        const videoDownloadUrl = videoDownloadResponse.data.result.url;
        const audioDownloadUrl = audioDownloadResponse.data.result.url;

        // Unduh video
        await downloadFile(videoDownloadUrl, videoFileName);
        await ctx.replyWithVideo({ source: videoFileName });

        // Unduh audio
        await downloadFile(audioDownloadUrl, audioFileName);
        await ctx.replyWithAudio({ source: audioFileName });

        // Hapus file sementara setelah dikirim
        fs.unlinkSync(videoFileName);
        fs.unlinkSync(audioFileName);
    } catch (error) {
        console.error("❌ Error:", error.message);
        return ctx.reply("❌ Terjadi kesalahan saat memproses permintaan Anda.");
    }
});

bot.command("ttmp4", async (ctx) => {
    try {
        const text = ctx.message.text.split(" ").slice(1).join(" "); // Ambil URL TikTok

        if (!text) {
            return ctx.reply("❌ Error: Masukkan URL video TikTok! Contoh: /ttmp4 https://vt.tiktok.com/ZSM2mSvAS/");
        }

        // Cek keanggotaan pengguna di channel
        const isMember = await checkChannelMembership(ctx);
        if (!isMember) {
            return ctx.replyWithMarkdown(
                "❌ E̶R̶R̶O̶R̶ │ ⓘ Anda harus bergabung ke channel di bawah ini terlebih dahulu sebelum memakai fitur ini!!",
                {
                    reply_markup: {
                        inline_keyboard: [
                            [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                        ]
                    }
                }
            );
        }

        // Kirimkan pesan ke pengguna untuk mengarahkan ke bot TikTok Downloader
        return ctx.replyWithMarkdown(
            "📥 Silakan kirim link TikTok Anda ke bot downloader di bawah ini untuk mengunduh video:",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🎥 Download via Bot", url: "https://t.me/downloader_tiktok_bot" }]
                    ]
                }
            }
        );

    } catch (error) {
        console.error(error);
        ctx.reply("❌ Error: Terjadi kesalahan.");
    }
});

// Command /enc (diperkuat dengan pemeriksaan channel)
bot.command("enc", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/enc [level]`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const args = ctx.message.text.split(" ");
    const encryptionLevel = ["low", "medium", "high"].includes(args[1]) ? args[1] : "high";
    const encryptedPath = path.join(__dirname, `encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (${encryptionLevel}) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );
        
        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        const fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 30, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 40, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan level: ${encryptionLevel}`);
        await updateProgress(ctx, progressMessage, 50, "Inisialisasi Hardened Enkripsi");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getObfuscationConfig(encryptionLevel));
        await updateProgress(ctx, progressMessage, 70, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 90, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi: encrypted-${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, `Enkripsi (${encryptionLevel})`);

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat mengenkripsi", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /enceval (diperkuat dengan pemeriksaan channel)
bot.command("enceval", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/enceval [level]`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const args = ctx.message.text.split(" ");
    const encryptionLevel = ["low", "medium", "high"].includes(args[1]) ? args[1] : "high";
    const encryptedPath = path.join(__dirname, `eval-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai Evaluasi (${encryptionLevel}) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk evaluasi: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        const fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        let evalResult;
        try {
            await updateProgress(ctx, progressMessage, 30, "Mengevaluasi Kode Asli");
            evalResult = eval(fileContent);
            if (typeof evalResult === "function") {
                evalResult = "Function detected (cannot display full output)";
            } else if (evalResult === undefined) {
                evalResult = "No return value";
            }
        } catch (evalError) {
            evalResult = `Evaluation error: ${evalError.message}`;
        }

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 40, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi dan mengevaluasi file dengan level: ${encryptionLevel}`);
        await updateProgress(ctx, progressMessage, 50, "Inisialisasi Hardened Enkripsi");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getObfuscationConfig(encryptionLevel));
        await updateProgress(ctx, progressMessage, 70, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 90, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi dan hasil evaluasi: ${file.file_name}`);
        await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot - Evaluation Result\n" +
            "```\n" +
            `✨ *Original Code Result:* \n\`\`\`javascript\n${evalResult}\n\`\`\`\n` +
            `_Level: ${encryptionLevel} | Powered by VANNN`
        );
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `eval-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi siap!*\n_SUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, `Evaluasi & Enkripsi (${encryptionLevel})`);

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat mengenkripsi/evaluasi", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encchina (diperkuat dengan pemeriksaan channel)
bot.command("encchina", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encchina`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `china-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Mandarin) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Mandarin obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Mandarin yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Mandarin Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getMandarinObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Mandarin: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `china-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Mandarin) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Mandarin Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Mandarin obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encarab (diperkuat dengan pemeriksaan channel)
bot.command("encarab", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }
    
    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encarab`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `arab-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Arab) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Arab obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Arab yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Arab Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getArabObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Arab: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `arab-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Arab) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Arab Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Arab obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encjapan (Japan-style obfuscation baru, diperkuat dengan pemeriksaan channel)
bot.command("encjapan", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encjapan`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `japan-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Japan) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Japan obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Japan yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Japan Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getJapanObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Japan: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `japan-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Japan) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Japan Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Japan obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encjapxab", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encjapxab`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `japan-arab-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Japan X Arab ) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Japan X Arab  obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Japan X Arab  yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Japan X Arab  Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getJapanxArabObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Japan X Arab : ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `japan-arab-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Japan X Arab ) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Japan X Arab  Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Japan X Arab  obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});
// Command /encnew (diperkuat dengan pemeriksaan channel)
bot.command("encnew", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }
    
    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encnew`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `new-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Advanced) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk New obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan metode baru yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Advanced Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getNewObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi metode baru: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `new-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Advanced) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Advanced Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat New obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encinvis", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encinvis`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `invis-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Invisible) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Invisible obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Invisible yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Invisible Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getInvisObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Invisible: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `invis-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Invisible) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Invisible Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Invisible obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encstealth", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encstealth`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `stealth-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Stealth) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Stealth obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Stealth yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Stealth Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getStealthObfuscationConfig());
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");
        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        log(`Mengirim file terenkripsi gaya Stealth: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `stealth-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Stealth) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Stealth Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Stealth obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("customenc", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    // Ambil nama kustom dari perintah
    const args = ctx.message.text.split(" ");
    if (args.length < 2 || !args[1]) {
        return ctx.replyWithMarkdown("❌ *Error:* Gunakan format `/customenc <nama>` dengan nama kustom!");
    }
    const customName = args[1].replace(/[^a-zA-Z0-9_]/g, ""); // Sanitasi input, hanya huruf, angka, dan underscore
    if (!customName) {
        return ctx.replyWithMarkdown("❌ *Error:* Nama kustom harus berisi huruf, angka, atau underscore!");
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/customenc <nama>`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `custom-${customName}-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Custom: ${customName}) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Custom obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Custom (${customName}) yang diperkuat`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Custom Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getCustomObfuscationConfig(customName));
        log(`Hasil obfuscation (50 char pertama): ${obfuscated.code.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        log(`Memvalidasi kode hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscated.code);
        } catch (postObfuscationError) {
            log(`Kode hasil obfuscation tidak valid: ${postObfuscationError.message}`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await fs.writeFile(encryptedPath, obfuscated.code);
        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");

        log(`Mengirim file terenkripsi gaya Custom: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `custom-${customName}-encrypted-${file.file_name}` },
            { caption: `✅ *File terenkripsi (Hardened Custom: ${customName}) siap!*\nSUKSES ENCRYPT BY VANNN 🕊`, parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, `Hardened Custom (${customName}) Obfuscation Selesai`);

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Custom obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /deobfuscate (diperbaiki untuk menangani Promise dan validasi)
bot.command("deobfuscate", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js yang diobfuscate dengan `/deobfuscate`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const deobfuscatedPath = path.join(__dirname, `deobfuscated-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai Deobfuscation (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES DECRYPT BY VANNN"
        );

        // Mengunduh file
        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk deobfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        // Validasi kode awal
        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode Awal");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        // Proses deobfuscation dengan webcrack
        log(`Memulai deobfuscation dengan webcrack: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 40, "Memulai Deobfuscation");
        const result = await webcrack(fileContent); // Pastikan await digunakan
        let deobfuscatedCode = result.code;

        // Penanganan jika kode dibundel
        let bundleInfo = "";
        if (result.bundle) {
            bundleInfo = "// Detected as bundled code (e.g., Webpack/Browserify)\n";
            log(`Kode terdeteksi sebagai bundel: ${file.file_name}`);
        }

        // Jika tidak ada perubahan signifikan atau hasil bukan string
        if (!deobfuscatedCode || typeof deobfuscatedCode !== "string" || deobfuscatedCode.trim() === fileContent.trim()) {
            log(`Webcrack tidak dapat mendekode lebih lanjut atau hasil bukan string: ${file.file_name}`);
            deobfuscatedCode = `${bundleInfo}// Webcrack tidak dapat mendekode sepenuhnya atau hasil invalid\n${fileContent}`;
        }

        // Validasi kode hasil
        log(`Memvalidasi kode hasil deobfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 60, "Memvalidasi Kode Hasil");
        let isValid = true;
        try {
            new Function(deobfuscatedCode);
            log(`Kode hasil valid: ${deobfuscatedCode.substring(0, 50)}...`);
        } catch (syntaxError) {
            log(`Kode hasil tidak valid: ${syntaxError.message}`);
            deobfuscatedCode = `${bundleInfo}// Kesalahan validasi: ${syntaxError.message}\n${deobfuscatedCode}`;
            isValid = false;
        }

        // Simpan hasil
        await updateProgress(ctx, progressMessage, 80, "Menyimpan Hasil");
        await fs.writeFile(deobfuscatedPath, deobfuscatedCode);

        // Kirim hasil
        log(`Mengirim file hasil deobfuscation: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: deobfuscatedPath, filename: `deobfuscated-${file.file_name}` },
            { caption: `✅ *File berhasil dideobfuscate!${isValid ? "" : " (Perhatikan pesan error dalam file)"}*\nSUKSES ENCRYPT BY VANNN 🕊`, parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Deobfuscation Selesai");

        // Hapus file sementara
        if (await fs.pathExists(deobfuscatedPath)) {
            await fs.unlink(deobfuscatedPath);
            log(`File sementara dihapus: ${deobfuscatedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat deobfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan file Javascript yang valid!_`);
        if (await fs.pathExists(deobfuscatedPath)) {
            await fs.unlink(deobfuscatedPath);
            log(`File sementara dihapus setelah error: ${deobfuscatedPath}`);
        }
    }
});

// Command /encstrong (Obfuscation baru dengan metode Strong)
bot.command("encstrong", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encstrong`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `strong-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Strong) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Strong obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Strong`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Strong Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getStrongObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated; // Pastikan string
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Strong: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `strong-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Strong) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Strong Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Strong obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});


// Command /encbig <size_in_mb> (Obfuscation dengan ukuran besar)
bot.command("encbig", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    // Ambil target ukuran dari perintah
    const args = ctx.message.text.split(" ");
    if (args.length < 2 || !args[1] || isNaN(args[1])) {
        return ctx.replyWithMarkdown("❌ *Error:* Gunakan format `/encbig <size_in_mb>` dengan ukuran dalam MB (angka)!");
    }
    const targetSizeMB = Math.max(1, parseInt(args[1], 10)); // Minimal 1 MB

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encbig <size_in_mb>`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `big-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Big: ${targetSizeMB}MB) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Big obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Big`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Big Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getBigObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated; // Pastikan string
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        // Tambahkan padding secara manual untuk meningkatkan ukuran
        const currentSizeBytes = Buffer.byteLength(obfuscatedCode, "utf8");
        const targetSizeBytes = targetSizeMB * 1024 * 1024; // Konversi MB ke bytes
        if (currentSizeBytes < targetSizeBytes) {
            const paddingSize = targetSizeBytes - currentSizeBytes;
            const padding = crypto.randomBytes(paddingSize).toString("base64");
            obfuscatedCode += `\n/* Binary Padding (${paddingSize} bytes) */\n// ${padding}`;
            log(`Padding ditambahkan: ${paddingSize} bytes`);
        }

        log(`Memvalidasi hasil obfuscation dengan padding: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid setelah padding: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Big: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `big-encrypted-${file.file_name}` },
            { caption: `✅ *File terenkripsi (Hardened Big: ${targetSizeMB}MB) siap!*\nSUKSES ENCRYPT BY VANNN 🕊`, parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, `Hardened Big (${targetSizeMB}MB) Obfuscation Selesai`);

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Big obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});



// Command /encultra (Obfuscation baru dengan metode Ultra)
bot.command("encultra", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encultra`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `ultra-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Ultra) (1%)\n` +
            ` ${createProgressBar(1)}\n` +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Ultra obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Ultra`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Ultra Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getUltraObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated; // Pastikan string
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Ultra: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `ultra-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened Ultra) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened Ultra Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Ultra obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encmax <intensity> (Obfuscation dengan metode Max dan intensitas yang dapat diatur)
bot.command("encmax", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    // Ambil intensitas dari perintah
    const args = ctx.message.text.split(" ");
    if (args.length < 2 || !args[1] || isNaN(args[1])) {
        return ctx.replyWithMarkdown("❌ *Error:* Gunakan format `/encmax <intensity>` dengan intensitas (1-10)!");
    }
    const intensity = Math.min(Math.max(1, parseInt(args[1], 10)), 10); // Batas 1-10

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encmax <intensity>`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `max-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            ` ⚙️ Memulai (Hardened Max Intensity ${intensity}) (1%)\n` +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Max obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Max (Intensity ${intensity})`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened Max Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getMaxObfuscationConfig(intensity));
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Max: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `max-encrypted-${file.file_name}` },
            { caption: `✅ *File terenkripsi (Hardened Max, Intensity ${intensity})*\nSUKSES ENCRYPT BY VANNN 🕊`, parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, `Hardened Max (Intensity ${intensity}) Obfuscation Selesai`);

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Max obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encquantum", async (ctx) => {
    users.add(ctx.from.id);
    saveUsers(users);

    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encquantum`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `quantum-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Quantum Vortex Encryption) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Quantum Vortex Encryption: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan Quantum Vortex Encryption`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Quantum Vortex Encryption");
        const obfuscatedCode = await obfuscateQuantum(fileContent);
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        log(`Ukuran file setelah obfuscation: ${Buffer.byteLength(obfuscatedCode, 'utf-8')} bytes`);

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${obfuscatedCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi quantum: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `quantum-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Quantum Vortex Encryption) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Quantum Vortex Encryption Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Quantum obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encx
bot.command("encx", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encx`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `x-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Hardened X Invisible) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk X obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya X`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Hardened X Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getXObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation sebelum encoding (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);

        // Tambahkan lapisan invisible encoding
        const encodedInvisible = encodeInvisible(obfuscatedCode);
        const finalCode = `
        (function(){
            function decodeInvisible(encodedText) {
                if (!encodedText.startsWith('\u200B')) return encodedText;
                try {
                    return Buffer.from(encodedText.slice(1), 'base64').toString('utf-8');
                } catch (e) {
                    return encodedText;
                }
            }
            try {
                const hiddenCode = "${encodedInvisible}";
                const decodedCode = decodeInvisible(hiddenCode);
                if (!decodedCode || decodedCode === hiddenCode) throw new Error("Decoding failed");
                eval(decodedCode);
            } catch (e) {
                console.error("Execution error:", e);
            }
        })();
        `;
        log(`Hasil obfuscation dengan invisible encoding (50 char pertama): ${finalCode.substring(0, 50)}...`);
        await updateProgress(ctx, progressMessage, 60, "Transformasi Kode");

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(finalCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${finalCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, finalCode);

        log(`Mengirim file terenkripsi gaya X: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `x-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Hardened X Invisible) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Hardened X Invisible Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat X obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Command /encnova
bot.command("encnova", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encnova`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `nova-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Nova Dynamic) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Nova obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Nova`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Nova Dynamic Obfuscation");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getNovaObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${obfuscatedCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Nova: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `nova-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Nova Dynamic) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Nova Dynamic Obfuscation Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Nova obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encnebula", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encnebula`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `nebula-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Nebula Polymorphic Storm) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Nebula obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Nebula`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Nebula Polymorphic Storm");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getNebulaObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        log(`Ukuran file setelah obfuscation: ${Buffer.byteLength(obfuscatedCode, 'utf-8')} bytes`);

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${obfuscatedCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Nebula: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `nebula-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Nebula Polymorphic Storm) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Nebula Polymorphic Storm Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Nebula obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("encsiu", async (ctx) => {
users.add(ctx.from.id);
    saveUsers(users);
    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/encsiu`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `siucalcrick-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Calcrick Chaos Core) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Siu+Calcrick obfuscation: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan gaya Siu+Calcrick`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Calcrick Chaos Core");
        const obfuscated = await JsConfuser.obfuscate(fileContent, getSiuCalcrickObfuscationConfig());
        let obfuscatedCode = obfuscated.code || obfuscated;
        if (typeof obfuscatedCode !== "string") {
            throw new Error("Hasil obfuscation bukan string");
        }
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        log(`Ukuran file setelah obfuscation: ${Buffer.byteLength(obfuscatedCode, 'utf-8')} bytes`);

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${obfuscatedCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi gaya Siu+Calcrick: ${file.file_name}`);
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `siucalcrick-encrypted-${file.file_name}` },
            { caption: "✅ *File terenkripsi (Calcrick Chaos Core) siap!*\nSUKSES ENCRYPT BY VANNN 🕊", parse_mode: "Markdown" }
        );
        await updateProgress(ctx, progressMessage, 100, "Calcrick Chaos Core Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Siu+Calcrick obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

bot.command("enclocked", async (ctx) => {
    users.add(ctx.from.id);
    saveUsers(users);

    const isMember = await checkChannelMembership(ctx);
    if (!isMember) {
        return ctx.replyWithMarkdown(
            "❌ E̶R̶R̶O̶R̶ │ ⓘ ᴀɴᴅᴀ ʜᴀʀᴜs ʙᴇʀɢᴀʙᴜɴɢ ᴋᴇ ᴄʜᴀɴɴᴇʟ ᴅɪ ʙᴀᴡᴀʜ ɪɴɪ ᴛᴇʀʟᴇʙɪʜ ᴅᴀʜᴜʟᴜ sᴇʙᴇʟᴜᴍ ᴍᴇᴍᴀᴋᴀɪ ʙᴏᴛ ᴏʙғ ɴʏᴀ!!",
            {
                reply_markup: {
                    inline_keyboard: [
                        [{ text: "🔗 Join Sekarang", url: "https://t.me/informationvan" }]
                    ]
                }
            }
        );
    }

    const args = ctx.message.text.split(" ").slice(1);
    if (args.length !== 1 || !/^\d+$/.test(args[0]) || parseInt(args[0]) < 1 || parseInt(args[0]) > 365) {
        return ctx.replyWithMarkdown("❌ *Error:* Gunakan format `/enclocked [1-365]` untuk jumlah hari (misal: `/enclocked 7`)!");
    }

    const days = args[0];
    const expiryDate = new Date();
    expiryDate.setDate(expiryDate.getDate() + parseInt(days));
    const expiryFormatted = expiryDate.toLocaleDateString();

    if (!ctx.message.reply_to_message || !ctx.message.reply_to_message.document) {
        return ctx.replyWithMarkdown("❌ *Error:* Balas file .js dengan `/enclocked [1-365]`!");
    }

    const file = ctx.message.reply_to_message.document;
    if (!file.file_name.endsWith(".js")) {
        return ctx.replyWithMarkdown("❌ *Error:* Hanya file .js yang didukung!");
    }

    const encryptedPath = path.join(__dirname, `locked-encrypted-${file.file_name}`);

    try {
        const progressMessage = await ctx.replyWithMarkdown(
            "```css\n" +
            "🔒 EncryptBot\n" +
            " ⚙️ Memulai (Time-Locked Encryption) (1%)\n" +
            " " + createProgressBar(1) + "\n" +
            "```\n" +
            "PROSES ENCRYPT BY VANNN"
        );

        const fileLink = await ctx.telegram.getFileLink(file.file_id);
        log(`Mengunduh file untuk Time-Locked Encryption: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 10, "Mengunduh");
        const response = await fetch(fileLink);
        let fileContent = await response.text();
        await updateProgress(ctx, progressMessage, 20, "Mengunduh Selesai");

        log(`Memvalidasi kode awal: ${file.file_name}`);
        await updateProgress(ctx, progressMessage, 30, "Memvalidasi Kode");
        try {
            new Function(fileContent);
        } catch (syntaxError) {
            throw new Error(`Kode awal tidak valid: ${syntaxError.message}`);
        }

        log(`Mengenkripsi file dengan Time-Locked Encryption`);
        await updateProgress(ctx, progressMessage, 40, "Inisialisasi Time-Locked Encryption");
        const obfuscatedCode = await obfuscateTimeLocked(fileContent, days);
        log(`Hasil obfuscation (50 char pertama): ${obfuscatedCode.substring(0, 50)}...`);
        log(`Ukuran file setelah obfuscation: ${Buffer.byteLength(obfuscatedCode, 'utf-8')} bytes`);

        log(`Memvalidasi hasil obfuscation: ${file.file_name}`);
        try {
            new Function(obfuscatedCode);
        } catch (postObfuscationError) {
            log(`Detail kode bermasalah: ${obfuscatedCode.substring(0, 100)}...`);
            throw new Error(`Hasil obfuscation tidak valid: ${postObfuscationError.message}`);
        }

        await updateProgress(ctx, progressMessage, 80, "Finalisasi Enkripsi");
        await fs.writeFile(encryptedPath, obfuscatedCode);

        log(`Mengirim file terenkripsi time-locked: ${file.file_name}`);
        await ctx.replyWithMarkdown(
            `✅ *File terenkripsi (Time-Locked Encryption) siap!*\n` +
            `⏰ Masa aktif: ${days} hari (Kedaluwarsa: ${expiryFormatted})\n` +
            `_Powered by VANNN`,
            { parse_mode: "Markdown" }
        );
        await ctx.replyWithDocument(
            { source: encryptedPath, filename: `locked-encrypted-${file.file_name}` }
        );
        await updateProgress(ctx, progressMessage, 100, "Time-Locked Encryption Selesai");

        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus: ${encryptedPath}`);
        }
    } catch (error) {
        log("Kesalahan saat Time-Locked obfuscation", error);
        await ctx.replyWithMarkdown(`❌ *Kesalahan:* ${error.message || "Tidak diketahui"}\n_Coba lagi dengan kode Javascript yang valid!_`);
        if (await fs.pathExists(encryptedPath)) {
            await fs.unlink(encryptedPath);
            log(`File sementara dihapus setelah error: ${encryptedPath}`);
        }
    }
});

// Jalankan bot
bot.launch(() => log("Encrypt Bot by VANNN berjalan..."));
process.on("unhandledRejection", (reason) => log("Unhandled Rejection", reason));